<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:msxsl="urn:schemas-microsoft-com:xslt">


<xsl:template match="/">
<html>

<head>
	<title>Microsoft Money Portfolio Manager</title>
	<style>
		.title { font: bold 100% Tahoma; }
		.subtitle { font: bold 70% Tahoma; }
		TH {font: bold 65% Tahoma;}
		.heading {font: bold 65%  tahoma; }
		.subtotal {font: bold 65%  tahoma; }
		.grandtotal {font: bold 65%  tahoma; }
		.data {font: 65%  tahoma; }
		HR { color: rgb(204,204,204)}
		
	</style>
</head>
<body>
	<center>
		<div class="title"><xsl:value-of select="portfolio/title"/></div>
		<div class="subtitle"><xsl:value-of select="portfolio/subtitle"/></div>
	</center>
	<table cellpadding="5px">
		<tr>
			<xsl:apply-templates select="portfolio/headers"/>
		</tr>
		<tr><td colspan="{count(//portfolio/headers/header)}"><hr size="1"/></td></tr>
		<xsl:apply-templates select="portfolio/rows/row"/>
	</table>
</body>
</html>
</xsl:template>

<xsl:template match="headers/header">
	<th>
		<xsl:value-of select="."/>
	</th>
</xsl:template>

<xsl:template match="row[@type='heading']">
	<tr>
		<td class="heading">
			<xsl:attribute name="COLSPAN">
				<xsl:value-of select="count(/portfolio/headers/header)"/>
			</xsl:attribute>
			<xsl:value-of select="value"/>
		</td>
	</tr>
</xsl:template>

<xsl:template match="row[@type='subtotal' or @type='grandtotal']">
	<tr>
		<td>
			<xsl:attribute name="COLSPAN">
				<xsl:value-of select="count(/portfolio/headers/header)"/>
			</xsl:attribute>
			<hr size="1"/>
		</td>
	</tr>
	<xsl:call-template name="values">
		<xsl:with-param name="className"><xsl:value-of select="@type"/></xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template match="row">
	<xsl:call-template name="values">
		<xsl:with-param name="className">data</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template name="values">
<xsl:param name="className"/>
	<tr>
		<xsl:for-each select="value">
			<td>
				<xsl:attribute name="class"><xsl:value-of select="$className"/></xsl:attribute>
				<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
				<xsl:value-of select="."/>
			</td>
		</xsl:for-each>
	</tr>
</xsl:template>



</xsl:stylesheet>
